/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.common.vo.MosPPasswordVo;

public class MosPPasswordAction extends MosPAction {

	// R}h
	private static final String CMD_PASSWORD_SHOW   		= "C1050";
	private static final String CMD_PASSWORD_CHANGE 		= "C1051";
	public  static final String CMD_PASSWORD_FORCE_CHANGE = "C1052";

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		MosPPasswordVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_PASSWORD_SHOW)) {
			// \
			vo.setUserId(user.getUserId());
			vo.setUserName(user.getUserName());
			// j[փ{^̕\
			vo.setMode(MosPPasswordVo.MODE_SHOW);
		} else if (cmd.equals(CMD_PASSWORD_CHANGE)) {
			// XV
			update(vo);
			// j[փ{^̕\
			vo.setMode(MosPPasswordVo.MODE_SHOW);
		} else if (cmd.equals(CMD_PASSWORD_FORCE_CHANGE)) {
			vo.setUserId(user.getUserId());
			vo.setUserName(user.getUserName());
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	protected MosPPasswordVo getInitVo() {
		return new MosPPasswordVo();
	}
	
	/**
	 * 
	 * @param vo	ΏVO
	 */
	private void init(MosPPasswordVo vo) {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// j[R}hݒ
		setCmdMenu(vo);
		// j[փ{^̔\ݒ
		vo.setMode(MosPPasswordVo.MODE_FORCE_UPDATE);
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void update(MosPPasswordVo vo) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		MosPUserDto dto = dao.findForUpdate(vo.getUserId());
		// ݊mF
		chkExist(dto);
		// p[^̑ÓmF
		vo.validate(dto.getPassword());
		// l̐ݒ
		dto.setPassword(MospUtility.getDigest(vo.getHdnNewPassword()));
		// f[^̍XV
		dao.update(dto, false);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
	}

	/**
	 * j[R}hݒ
	 * @param vo ݒΏVO
	 */
	private void setCmdMenu(MosPPasswordVo vo) {
		if (user.getMospAuthority().equals(CommonConst.AUTH_SYSTEM)) {
			vo.setCmdMenu(vo.CMD_MENU_SYSTEM2);
		} else {
			vo.setCmdMenu(vo.CMD_MENU_INPUT);
		}
	}

}
